package gov.va.caret.model.support;

import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.BaseModel;

import gov.va.caret.model.AudLg;
import gov.va.caret.model.AudLgWrapper;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.WorImWrapper;
import gov.va.caret.util.Toolbox;

public class AuditLogSupport extends AudLgWrapper {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	String fullName = StringPool.BLANK;
	
	String modifiedByFullName = StringPool.BLANK;
	String docDeleteComment = StringPool.BLANK;
	String modifiedDateStr = StringPool.BLANK;
	String documentDeleteNote = StringPool.BLANK;
	String documentName = StringPool.BLANK;
	


	public AuditLogSupport(AudLg audLg) {
		super(audLg);
	}
	
	public String getModificationDate(){
		return Toolbox.getDateTimeFormat().format( getModifiedDate() );
	}
	
	public String getModifiedBy(){
		if ( getModifiedById() > 0 && fullName == StringPool.BLANK ) {
			fullName = Toolbox.getUserFullName( getModifiedById() ); 
		}
		return fullName;
	}
	
	public String getModifiedByFullName() {
		return modifiedByFullName;
	}

	public void setModifiedByFullName(String modifiedByFullName) {
		this.modifiedByFullName = modifiedByFullName;
	}

	public String getDocDeleteComment() {
		return docDeleteComment;
	}

	public void setDocDeleteComment(String docDeleteComment) {
		this.docDeleteComment = docDeleteComment;
	}

	public String getModifiedDateStr() {
		return modifiedDateStr;
	}

	public void setModifiedDateStr(String modifiedDateStr) {
		this.modifiedDateStr = modifiedDateStr;
	}

	public String getDocumentDeleteNote() {
		return documentDeleteNote;
	}

	public void setDocumentDeleteNote(String documentDeleteNote) {
		this.documentDeleteNote = documentDeleteNote;
	}

	public String getDocumentName() {
		return documentName;
	}

	public void setDocumentName(String documentName) {
		this.documentName = documentName;
	}

	@SuppressWarnings("rawtypes")
	public static BaseModel getWrappedModel ( BaseModel model, BaseModel<?> modelType ){

		if ( model instanceof Persn ){
			if ( modelType instanceof Veteran ){
				return new Veteran( (Persn) model );
			} else if ( modelType instanceof Primary ){
				return new Primary( (Persn) model );
			} else if ( modelType instanceof Secondary ){
				return new Secondary( (Persn) model );
			} else if ( modelType instanceof SecondaryTwo ){
				return new SecondaryTwo( (Persn) model );
			} else if ( modelType instanceof General ){
				return new General( (Persn) model );
			}
			return new Person( (Persn) model );
		}
		
		if ( model instanceof Vendr ){
			return new Vendor( (Vendr)model );
		}
		if ( model instanceof VcgAn ){
			return new VcgApplication( (VcgAn) model );
		}
		if ( model instanceof Vcg ){
			return new VcgSupport( (Vcg) model );
		}
		if ( model instanceof WorImWrapper ){
			return new WorkItemSupport ( (WorIm) model );
		}
		return model;
	}

}
